/*
 * Decompiled with CFR 0.152.
 */
package panther.util.unicon;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class StringUtil {
    private static char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String toUnicodeEscapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block6;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block6;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block6;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block6;
                }
                default: {
                    if (c >= ' ' && c <= '\u007f') {
                        stringBuffer.append(c);
                        continue block6;
                    }
                    stringBuffer.append('\\');
                    stringBuffer.append('u');
                    stringBuffer.append(StringUtil.toHex(c >> 12 & 0xF));
                    stringBuffer.append(StringUtil.toHex(c >> 8 & 0xF));
                    stringBuffer.append(StringUtil.toHex(c >> 4 & 0xF));
                    stringBuffer.append(StringUtil.toHex(c >> 0 & 0xF));
                }
            }
        }
        return stringBuffer.toString();
    }

    private static char toHex(int n) {
        return hexDigit[n & 0xF];
    }

    public static String fromUTF8(String string) throws UnsupportedEncodingException {
        return StringUtil.translate(string, "UTF-8");
    }

    public static String translate(String string, String string2) throws UnsupportedEncodingException {
        return new String(string.getBytes(), string2);
    }

    public static String commaSeparated(String[] stringArray) {
        if (stringArray == null || stringArray.length <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append(", ");
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String concatStrings(Collection collection, String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        Iterator iterator = collection.iterator();
        if (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
        }
        while (iterator.hasNext()) {
            stringBuffer.append(string);
            stringBuffer.append(iterator.next());
        }
        return stringBuffer.toString();
    }

    public static String commaSeparated(Collection collection) {
        return StringUtil.concatStrings(collection, ",");
    }

    public static String replace(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.indexOf(string2);
        while (n2 != -1) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string3);
            n = n2 + string2.length();
            n2 = string.indexOf(string2, n2 + 1);
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static String wrap(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\n': {
                    if (!bl3) {
                        if (!bl2) {
                            stringBuffer.append('\n');
                            n2 = 0;
                            ++n3;
                            break;
                        }
                        stringBuffer.append("\n\n");
                        n2 = 0;
                        n3 += 2;
                        bl2 = false;
                        break;
                    }
                    if (!bl) {
                        stringBuffer.append(' ');
                        n4 = n3++;
                        ++n2;
                    }
                    bl2 = true;
                    bl3 = false;
                    break;
                }
                case ' ': {
                    stringBuffer.append(' ');
                    n4 = n3++;
                    bl = true;
                    ++n2;
                    break;
                }
                case '\t': {
                    stringBuffer.append("     ");
                    n4 = n3 + 4;
                    bl = true;
                    n2 += 5;
                    n3 += 5;
                    break;
                }
                default: {
                    stringBuffer.append(string.charAt(i));
                    bl = false;
                    bl2 = false;
                    ++n2;
                    ++n3;
                }
            }
            if (n2 < n) continue;
            if (n4 == 0) {
                stringBuffer.setCharAt(n3, '\n');
                n2 = 0;
            } else {
                stringBuffer.setCharAt(n4, '\n');
                n2 = n3 - n4;
            }
            bl3 = true;
        }
        return stringBuffer.toString();
    }

    public static List listFromDelimitedString(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreElements()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }
}

